/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.skills.SAO.skillevents;

import com.dfdyz.epicacg.client.particle.SAO.LandingStrikeParticle;
import com.dfdyz.epicacg.efmextra.anims.DeferredDamageAttackAnimation;
import com.dfdyz.epicacg.event.CameraEvents;
import com.dfdyz.epicacg.registry.MobEffects;
import com.dfdyz.epicacg.registry.MyAnimations;
import com.dfdyz.epicacg.utils.RenderUtils;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.entity.PartEntity;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class SAOSkillAnimUtils {
    public static void playSound(Entity entity, SoundEvent soundEvent) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, entity.m_5720_(), 1.0f, 1.0f);
    }

    public static void HurtEntity(LivingEntityPatch<?> attacker, Entity target, StaticAnimation animation, float damageRate, float cutRate) {
        EpicFightDamageSource source = attacker.getDamageSource(animation, InteractionHand.MAIN_HAND);
        if (source.getDamageModifier() == null) {
            source.setDamageModifier(new ValueModifier(0.0f, damageRate, 0.0f));
        } else {
            source.getDamageModifier().merge(new ValueModifier(0.0f, damageRate, 0.0f));
        }
        LivingEntity rootEntity = SAOSkillAnimUtils.getTrueEntity(target);
        int prevInvulTime = target.f_19802_;
        target.f_19802_ = 0;
        AttackResult attackResult = attacker.attack(source, target, InteractionHand.MAIN_HAND);
        target.f_19802_ = prevInvulTime;
        if (rootEntity != null) {
            float dmg = rootEntity.m_21233_() * 0.05f + attackResult.damage;
            target.m_6469_(((LivingEntity)attacker.getOriginal()).m_9236_().m_269111_().m_269264_(), dmg += cutRate * (rootEntity.m_21233_() - rootEntity.m_21223_()));
        }
    }

    public static LivingEntity getTrueEntity(Entity entity) {
        PartEntity partEntity;
        Entity parentEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        if (entity instanceof PartEntity && (parentEntity = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)parentEntity;
            return livingEntity;
        }
        return null;
    }

    public static class DualSwordSA {
        public static void LandingStrike(Entity entity) {
            LandingStrikeParticle particle = new LandingStrikeParticle((ClientLevel)entity.m_9236_(), entity.m_20182_().m_82520_(0.0, (double)0.8f, 0.0));
            particle.m_107253_(0.0f, 0.9647059f, 1.0f);
            RenderUtils.AddParticle((ClientLevel)entity.m_9236_(), particle);
        }
    }

    public static class RapierSA {
        public static void prev(LivingEntityPatch<?> entityPatch) {
            CameraEvents.SetAnim(MyAnimations.SAO_RAPIER_SA2_CAM, (LivingEntity)entityPatch.getOriginal(), true);
        }

        public static void HandleAtk1(LivingEntityPatch<?> entityPatch) {
            if (!entityPatch.isLogicalClient() && entityPatch.getCurrenltyAttackedEntities().size() > 0) {
                entityPatch.getCurrenltyAttackedEntities().forEach(entity -> {
                    if (entity != null && entity.m_6084_() && entity.equals((Object)entityPatch.getOriginal())) {
                        return;
                    }
                    entity.m_7292_(new MobEffectInstance((MobEffect)MobEffects.STOP.get(), 13, 1));
                });
            }
        }

        public static void HandleAtk2(LivingEntityPatch<?> entityPatch) {
            List<Entity> EntityMap;
            if (!entityPatch.isLogicalClient() && (EntityMap = DeferredDamageAttackAnimation.getScannedEntities(entityPatch)).size() > 0) {
                EntityMap.forEach(entity -> {
                    if (entity != null && entity.m_6084_() && entity.equals((Object)entityPatch.getOriginal())) {
                        return;
                    }
                    SAOSkillAnimUtils.HurtEntity(entityPatch, entity, MyAnimations.SAO_RAPIER_SA2, 1.7f, 0.2f);
                });
            }
        }

        public static void post(LivingEntityPatch<?> entityPatch) {
            CameraEvents.SetAnim(MyAnimations.SAO_RAPIER_SA2_CAM2, (LivingEntity)entityPatch.getOriginal(), true);
        }
    }
}

